PROCGEN_INSTRUCT = {
    "bigfish": '''
    The player starts as a small fish and becomes bigger by eating other fish. The player may only eat fish smaller than itself, as determined solely by width. If the player comes in contact with a larger fish, the player is eaten and the episode ends. The player receives a small reward for eating a smaller fish and a large reward for becoming bigger than all other fish, at which point the episode ends.
    ''',
    "bossfight": '''
    The player controls a small starship and must destroy a much bigger boss starship. The boss randomly selects from a set of possible attacks when engaging the player. The player must dodge the incoming projectiles or be destroyed. The player can also use randomly scattered meteors for cover. After a set timeout, the boss becomes vulnerable and its shields go down. At this point, the players projectile attacks will damage the boss. Once the boss receives a certain amount of damage, the player receives a reward, and the boss re-raises its shields. If the player damages the boss several times in this way, the boss is destroyed, the player receives a large reward, and the episode ends.
    ''',
    "caveflyer": '''
    The player must navigate a network of caves to reach the exit. Player movement mimics the Atari game “Asteroids”: the ship can rotate and travel forward or backward along the current axis. The majority of the reward comes from successfully reaching the end of the level, though additional reward can be collected by destroying target objects along the way with the ship's lasers. There are stationary and moving lethal obstacles throughout the level.
    ''',
    "chaser": '''
    Inspired by the Atari game “MsPacman”. Maze layouts are generated using Kruskal’s algorithm, and then walls are removed until no dead-ends remain in the maze. The player must collect all the green orbs. 3 large stars spawn that will make enemies vulnerable for a short time when collected. A collision with an enemy that isn’t vulnerable results in the player’s death. When a vulnerable enemy is eaten, an egg spawns somewhere on the map that will hatch into a new enemy after a short time, keeping the total number of enemies constant. The player receives a small reward for collecting each orb and a large reward for completing the level.
    ''',
    "climber": '''
    A simple platformer. The player must climb a sequence of platforms, collecting stars along the way. A small reward is given for collecting a star, and a larger reward is given for collecting all stars in a level. If all stars are collected, the episode ends. There are lethal flying monsters scattered throughout the level.
    ''',
    "coinrun": '''
    A simple platformer. The goal is to collect the coin at the far right of the level, and the player spawns on the far left. The agent must dodge stationary saw obstacles, enemies that pace back and forth, and chasms that lead to death. Note that while the previously released version of CoinRun painted velocity information directly onto observations, the current version does not. This makes the environment significantly more difficult.
    ''',
    "dodgeball": '''
    Loosely inspired by the Atari game “Berzerk”. The player spawns in a room with a random configuration of walls and enemies. Touching a wall loses the game and ends the episode. The player moves relatively slowly and can navigate throughout the room. There are enemies which also move slowly and which will occasionally throw balls at the player. The player can also throw balls, but only in the direction they are facing. If all enemies are hit, the player can move to the unlocked platform and earn a significant level completion bonus.
    ''',
    "fruitbot": '''
    A scrolling game where the player controls a robot that must navigate between gaps in walls and collect fruit along the way. The player receives a positive reward for collecting a piece of fruit, and a larger negative reward for mistakenly collecting a non-fruit object. Half of the spawned objects are fruit (positive reward) and half are non-fruit (negative reward). The player receives a large reward if they reach the end of the level. Occasionally the player must use a key to unlock gates which block the way.
    ''',
    "heist": '''
    The player must steal the gem hidden behind a network of locks. Each lock comes in one of three colors, and the necessary keys to open these locks are scattered throughout the level. The level layout takes the form of a maze, again generated by Kruskal's algorithm. Once the player collects a key of a certain color, the player may open the lock of that color. All keys in the player's possession are shown in the top right corner of the screen.
    ''',
    "jumper": '''
    A platformer with an open world layout. The player, a bunny, must navigate through the world to find the carrot. It might be necessary to ascend or descend the level to do so. The player is capable of “double jumping”, allowing it to navigate tricky layouts and reach high platforms. There are spike obstacles which will destroy the player on contact. The screen includes a compass which displays direction and distance to the carrot. The only reward in the game comes from collect the carrot, at which point the episode ends. Due to a bug that permits the player to spawn on top of critical objects (an obstacle or the goal), ~7% of levels will terminate after a single action, the vast majority of which will have 0 reward.
    ''',
    "leaper": '''
    Inspired by the classic game “Frogger”. The player must cross several lanes to reach the finish line and earn a reward. The first group of lanes contains cars which must be avoided. The second group of lanes contains logs on a river. The player must hop from log to log to cross the river. If the player falls in the river, the episode ends.
    ''',
    "maze": '''
    The player, a mouse, must navigate a maze to find the sole piece of cheese and earn a reward. Mazes are generated by Kruskal's algorithm and range in size from 3x3 to 25x25. The maze dimensions are uniformly sampled over this range. The player may move up, down, left or right to navigate the maze.
    ''',
    "miner": '''
    Inspired by the classic game “BoulderDash”. The player, a robot, can dig through dirt to move throughout the world. The world has gravity, and dirt supports boulders and diamonds. Boulders and diamonds will fall through free space and roll off each other. If a boulder or a diamond falls on the player, the game is over. The goal is to collect all the diamonds in the level and then proceed through the exit. The player receives a small reward for collecting a diamond and a larger reward for completing the level.
    ''',
    "ninja": '''
    A simple platformer. The player, a ninja, must jump across narrow ledges while avoiding bomb obstacles. The player can toss throwing stars at several angles in order to clear bombs, if necessary. The player's jump can be charged over several timesteps to increase its effect. The player receives a reward for collecting the mushroom at the end of the level, at which point the episode terminates.
    ''',
    "plunder": '''
    The player must destroy enemy pirate ships by firing cannonballs from its own ship at the bottom of the screen. An on-screen timer slowly counts down. If this timer runs out, the episode ends. Whenever the player fires, the timer skips forward a few steps, encouraging the player to conserve ammunition. The player must take care to avoid hitting friendly ships. The player receives a positive reward for hitting an enemy ship and a large timer penalty for hitting a friendly ship. A target in the bottom left corner identifies the color of the enemy ships to target.
    ''',
    "starpilot": '''
    A simple side scrolling shooter game. Relatively challenging for humans to play since all enemies fire projectiles that directly target the player. An inability to dodge quickly leads to the player's demise. There are fast and slow enemies, stationary turrets with high health, clouds which obscure player vision, and impassable meteors.
    ''',
}


PROCGEN_INSTRUCT_SHORT = {
    "coinrun": '''
    A simple platformer. The goal is to collect the coin at the far right of the level, and the player spawns on the far left. The agent must dodge stationary saw obstacles, enemies that pace back and forth, and chasms that lead to death.
    ''',
    "maze": '''
    The player must navigate a maze to find the yellow cheese and earn a reward. Mazes are range in size from 3x3 to 25x25. The player may move up, down, left or right to navigate the maze.
    ''',
    "caveflyer": '''You must navigate a network of caves to reach the exit. You must successfully reach the end first. And you must destroy target objects with the ship's lasers. You must avoid stationary and moving lethal obstacles.''',
}

PROCGEN_INSTRUCT_MORE_SHORT = {
    # "coinrun": '''The goal is to collect the coin, and the player spawns on the far left. The agent must dodge stationary saw obstacles, enemies, and chasms''',
    "coinrun": '''The goal is to collect the coin, and the player spawns on the far left. The agent must dodge stationary saw obstacles, enemies, and chasms.''',
    "maze": '''The player must navigate a maze to find the cheese. The player may move up, down, left or right to navigate the maze.''',
    "maze_aisc": '''The player must navigate a maze to find the cheese. The player may move up, down, left or right to navigate the maze.''',
    "maze_yellowline": '''The player must navigate a maze to find the cheese. The player may move up, down, left or right to navigate the maze.''',
    "heist": '''The player must steal the gem hidden behind a network of locks. The player must collect a key of a certain color to open a lock. All keys in the player's possession are shown in the top right corner of the screen.'''

}

PROCGEN_POS_NEG_INSTRUCT = {
    "coinrun": [
        "The goal is to collect the coin.",
        "The agent must navigate to the far right wall."
    ],
    "coinrun_mugen": [
        "Mugen runs from left to right and it collects coins.",
        "Mugen runs to the far right wall."
    ],
    "coinrun_randomaction": [
        "The goal is to collect the coin.",
        "The agent must navigate to the far right wall."
    ],
    "coinrun_randomaction_mugen": [
        "Mugen runs from left to right and it collects coins.",
        "Mugen runs to the far right wall."
    ],
    "coinrun_aisc": [
        "The goal is to collect the coin.",
        "The agent must navigate to the far right wall."
    ],
    "coinrun_aisc_mugen": [
        "Mugen runs from left to right and it collects coins.",
        "Mugen runs to the far right wall."
    ],
    "maze_yellowline": [
        "The agent must navigate a maze to find the line.", 
        "The agent navigate to the yellow object."
    ],
    "maze_yellowline_mugen": [
        "Mugen collects the line.",
        "Mugen collects the yellow object."
    ],
    "maze_redline_yellowgem": [
        "The agent must navigate a maze to find the line.", 
        "The agent navigate to the yellow object."
    ],
    "maze_redline_yellowgem_mugen": [
        "Mugen collects the line.",
        "Mugen collects the yellow object."
    ],
    "maze": [
        "The agent must navigate a maze to find the yellow cheese.", 
        # "The agent must navigate to the far right wall."
        "The agent navigate to the top right." 
    ],
    "maze_mugen": [
        "Mugen collects yellow cheese.",
        "Mugen runs to the top right."
    ],
    "maze_aisc": [
        "The agent must navigate a maze to find the yellow cheese.", 
        # "The agent must navigate to the far right wall."
        "The agent navigate to the top right." 
    ],
    "maze_aisc_mugen": [
        "Mugen collects yellow cheese.",
        "Mugen runs to the top right."
    ],
    "maze_yellowstar_redgem": [
        "The agent must navigate a maze to find the yellow objects.", 
        "The agent must dodge the red objects."
    ]
}